var EVT_OBJ_ERROR_CHECKING = false;

var arrEventLists = new Array();
var DEFAULT_NODE_EVENTS = 0;
arrEventLists[0] = "reorder,completed,attempted,satisfied,score,skip,block,enabled,visible,choice,flow,forwardOnly";
var DEFAULT_RULE_EVENTS = 1;
arrEventLists[1] = "changed";
var DEFAULT_OBJECTIVE_EVENTS = 2;
arrEventLists[2] = "score,satisfied";

function EventsObject(arg1)
{
	this.eventHash = new HashTable(13);
	this.callbackHash = new HashTable(13);
	this.eventNames = "";
	
	if (typeof(arg1) == "number")
	{
		this.eventNames = arrEventLists[arg1];
	}
	else
	{
		this.registerEventNames(arguments);
	}

	this.uid = 0;
	this.eventQueue = new Array();
	this.owner = null;
}
EventsObject.prototype.registerEventNames = EventsObjectRegisterEventNames;
EventsObject.prototype.raiseEvent = EventsObjectRaiseEvent;
EventsObject.prototype.registerEvent = EventsObjectRegisterQueuedEvent;
EventsObject.prototype._registerEvent = EventsObjectRegisterEvent;
EventsObject.prototype.unregisterEvent = EventsObjectUnregisterEvent;
EventsObject.prototype.registerQueuedEvents = EventsObjectRegisterQueuedEvents;

function EventsObjectRegisterQueuedEvents()
{
	for (var i=0;i<this.eventQueue.length;i++)
	{
		this._registerEvent(this.eventQueue[i].strEvent, this.eventQueue[i].func, this.eventQueue[i].obj, true);
	}
	this.eventQueue.length = 0;
}

function EventsObjectRegisterEventNames(arrArgs)
{
	var arrEventNames = null;
	if (!arrArgs) arrArgs = new Array();
	if (this.eventNames != "")
	{
		arrEventNames = this.eventNames.split(",");
		for (var i=0;i<arrArgs.length;i++) arrEventNames[arrEventNames.length] = arrArgs[i];
		this.eventNames = "";
	}
	else
	{
		arrEventNames = arrArgs;
	}
	
	for (var i=0;i<arrEventNames.length;i++)
	{
		this.eventHash.insert(arrEventNames[i].toLowerCase(), new Array());
	}
}

function EventsObjectUnregisterEvent(callbackId, suppressErrors)
{
	if (suppressErrors == null) suppressErrors = false;
	
	this.registerEventNames();
	this.registerQueuedEvents();

	if (callbackId != null)
	{
		var objCallback = this.callbackHash.retrieve(callbackId);
		this.callbackHash.remove(callbackId);
		
		if (objCallback != null)
		{
			var evtArr = this.eventHash.retrieve(objCallback.strEvent);
			for (var i=0;i<evtArr.length;i++)
			{
				if (evtArr[i] == callbackId)
				{
					_Splice(evtArr,i,1);
					return;
				}
			}
		}
		else
		{
			if (!suppressErrors)
			{
				alert("Error in call to EventsObject.unregisterEvent(): the callback with id, \"" + callbackId + "\" is not registered.");
			}
		}
	}
}

function EventsObjectRegisterQueuedEvent(strEvent, strEvtHandler, evtContext, suppressErrors, queueRegistration)
{
	if (queueRegistration == true)
	{
		this.eventQueue[this.eventQueue.length] = new CallbackObject(strEvent.toLowerCase(), strEvtHandler, evtContext);
		return null;
	}
	else
	{
		return this._registerEvent(strEvent, strEvtHandler, evtContext, suppressErrors);
	}
}

function EventsObjectRegisterEvent(strEvent, strEvtHandler, evtContext, suppressErrors)
{	
	var retVal = null;

	if (suppressErrors == null) suppressErrors = false;

	if (EVT_OBJ_ERROR_CHECKING)
	{
		if (typeof(strEvent) != "string")
		{
			if (!suppressErrors)
				alert("Error in call to EventsObject._registerEvent(strEvent, strEvtHandler, evtContext): the parameter strEvent must be of type \"string\", not type \"" + typeof(strEvent) + "\":\n\n" + strEvent);
			return retVal;
		}
		if (typeof(strEvtHandler) != "string")
		{
			if (!suppressErrors)
				alert("Error in call to EventsObject._registerEvent(strEvent, strEvtHandler, evtContext): the parameter strEvtHandler must be of type \"string\", not type \"" + typeof(strEvtHandler) + "\":\n\n" + strEvtHandler);
			return retVal;
		}
		if (evtContext != null && typeof(evtContext) != "object")
		{
			if (!suppressErrors)
				alert("Error in call to EventsObject._registerEvent(strEvent, strEvtHandler, evtContext): the parameter evtContext must be of type \"object\", not type \"" + typeof(evtContext) + "\":\n\n" + evtContext);
			return retVal;
		}
	}
	
	this.registerEventNames();
	// get array from eventHash that contains uids of callbacks
	var eventArray = this.eventHash.retrieve(strEvent.toLowerCase());

	if (eventArray != null)
	{
		var newCallback = new CallbackObject(strEvent.toLowerCase(), strEvtHandler, evtContext);
		
		if (EVT_OBJ_ERROR_CHECKING)
		{
			// Loop through all handlers for this event, checking for duplicates.
			for (var i=0;i<eventArray.length;i++)
			{
				var oldCallback = this.callbackHash.retrieve(eventArray[i]);
				if (oldCallback.func == newCallback.func && oldCallback.obj == newCallback.obj)
				{
					// If duplicate found, then return immediately.
					return;
				}
			}
		}

		eventArray[eventArray.length] = this.uid;
		this.callbackHash.insert(this.uid, newCallback);
		retVal = this.uid.toString();
		this.uid++;
	}
	else
	{
		if (!suppressErrors)
			alert("Error in call to EventsObject._registerEvent(): the event, \"" + strEvent + "\" is not defined.");
	}
	return retVal;
}

var _globalObj = null;
var _globalVal1 = null;
var _globalVal2 = null;
// Returns false if any one of the registered event handlers returns false.
// Returns true otherwise.
function EventsObjectRaiseEvent(strEvent, value1, value2, suppressErrors)
{
	var retVal = true;
	
	if (this.owner && this.owner.eventMonitor && typeof(this.owner.eventMonitor) == "function")
	{
		if (!this.owner.eventMonitor(strEvent, value1, value2)) return;
	}

	this.registerEventNames();
	this.registerQueuedEvents();
	
	var evtArr = this.eventHash.retrieve(strEvent.toLowerCase());
	
	if (evtArr != null)
	{
		evtArr = evtArr.concat();
		for (var i=0;i<evtArr.length;i++)
		{
			_globalVal1 = value1;
			_globalVal2 = value2;
			var objCallback = this.callbackHash.retrieve(evtArr[i]);
			if (objCallback.obj == null)
			{
				// If the function is not valid then the event handler will be removed
				// from the callback array (this will prevent errors handing event handlers
				// that do not exist).
				if (eval("typeof(" + objCallback.func + ")") != "function" && !(eval(objCallback.func) != null && eval(objCallback.func + ".constructor") != null))
				{
					this.unregisterEvent(evtArr[i]);
				}
				else
				{
					if (eval(objCallback.func + "(_globalVal1,_globalVal2)") == false)
					{
						retVal = false;
					}
				}
			}
			else
			{
				// If the object or function is not valid then the event handler will be removed
				// from the callback array (this will prevent errors handing event handlers
				// that do not exist).
				if (objCallback.obj.closed == true || (eval("typeof(objCallback.obj." + objCallback.func + ")") != "function" && !(eval("objCallback.obj." + objCallback.func) != null && eval("objCallback.obj." + objCallback.func + ".constructor") != null)))
				{
					this.unregisterEvent(evtArr[i]);
				}
				else
				{
					_globalObj = objCallback.obj;
					if (eval("_globalObj." + objCallback.func + "(_globalVal1,_globalVal2)") == false)
					{
						retVal = false;
					}					
				}
			}
		}
	}
	else
	{
		if (!suppressErrors)
			alert("Error in call to EventsObject.raiseEvent(): the event, \"" + strEvent + "\" is not defined.");
	}
	
	return retVal;
}

function CallbackObject(strEvent, func, obj)
{
	this.strEvent = strEvent;
	this.func = func;
	this.obj = obj;
}